/*
 * common.cpp
 *
 *  Created on: 2020.07.16
 *      Author: JackyPan
 */
#include "maincontroller.h"

static bool _soft_armed=false;//心跳包中表示是否解锁的标志位
static bool _thr_force_decrease=false;//强制油门下降
static bool _vel_d_constrain=false;
ROBOT_STATE robot_state=STATE_NONE;
ROBOT_STATE robot_state_desired=STATE_NONE;
ROBOT_MAIN_MODE robot_main_mode=MODE_AIR;
ROBOT_SUB_MODE robot_sub_mode=MODE_STABILIZE;
ROBOT_SPEC_MODE robot_spec_mode=MODE_ATTITUDE;
uint8_t a8mini_data[256];

bool get_soft_armed(void){
	return _soft_armed;
}

void set_soft_armed(bool soft_armed){
	_soft_armed=soft_armed;
}

bool get_thr_force_decrease(void){
	return _thr_force_decrease;
}

void set_thr_force_decrease(bool force_decrease){
	_thr_force_decrease=force_decrease;
}

bool get_constrain_vel_d(void){
	return _vel_d_constrain;
}

void set_constrain_vel_d(bool constrain){
	_vel_d_constrain=constrain;
}

bool mode_init(void){
	if(robot_sub_mode!=MODE_AUTONAV){
		if(mode_autonav_init()){
			robot_sub_mode=MODE_AUTONAV;
			return true;
		}else{
			return false;
		}
	}else{
		return true;
	}
}

//should be run at 400hz
void mode_update(void){
	if(mode_init()){
		mode_autonav();
	}
}

/***********************************************************
CRC16 Coding & Decoding G(X) = X^16+X^12+X^5+1
***********************************************************/
static const uint16_t crc16_tab[256]=
{0x0,0x1021,0x2042,0x3063,0x4084,0x50a5,0x60c6,0x70e7,

0x8108,0x9129,0xa14a,0xb16b,0xc18c,0xd1ad,0xe1ce,0xf1ef,

0x1231,0x210,0x3273,0x2252,0x52b5,0x4294,0x72f7,0x62d6,

0x9339,0x8318,0xb37b,0xa35a,0xd3bd,0xc39c,0xf3ff,0xe3de,

0x2462,0x3443,0x420,0x1401,0x64e6,0x74c7,0x44a4,0x5485,

0xa56a,0xb54b,0x8528,0x9509,0xe5ee,0xf5cf,0xc5ac,0xd58d,

0x3653,0x2672,0x1611,0x630,0x76d7,0x66f6,0x5695,0x46b4,

0xb75b,0xa77a,0x9719,0x8738,0xf7df,0xe7fe,0xd79d,0xc7bc,

0x48c4,0x58e5,0x6886,0x78a7,0x840,0x1861,0x2802,0x3823,

0xc9cc,0xd9ed,0xe98e,0xf9af,0x8948,0x9969,0xa90a,0xb92b,

0x5af5,0x4ad4,0x7ab7,0x6a96,0x1a71,0xa50,0x3a33,0x2a12,

0xdbfd,0xcbdc,0xfbbf,0xeb9e,0x9b79,0x8b58,0xbb3b,0xab1a,

0x6ca6,0x7c87,0x4ce4,0x5cc5,0x2c22,0x3c03,0xc60,0x1c41,

0xedae,0xfd8f,0xcdec,0xddcd,0xad2a,0xbd0b,0x8d68,0x9d49,

0x7e97,0x6eb6,0x5ed5,0x4ef4,0x3e13,0x2e32,0x1e51,0xe70,

0xff9f,0xefbe,0xdfdd,0xcffc,0xbf1b,0xaf3a,0x9f59,0x8f78,

0x9188,0x81a9,0xb1ca,0xa1eb,0xd10c,0xc12d,0xf14e,0xe16f,

0x1080,0xa1,0x30c2,0x20e3,0x5004,0x4025,0x7046,0x6067,

0x83b9,0x9398,0xa3fb,0xb3da,0xc33d,0xd31c,0xe37f,0xf35e,

0x2b1,0x1290,0x22f3,0x32d2,0x4235,0x5214,0x6277,0x7256,

0xb5ea,0xa5cb,0x95a8,0x8589,0xf56e,0xe54f,0xd52c,0xc50d,

0x34e2,0x24c3,0x14a0,0x481,0x7466,0x6447,0x5424,0x4405,

0xa7db,0xb7fa,0x8799,0x97b8,0xe75f,0xf77e,0xc71d,0xd73c,

0x26d3,0x36f2,0x691,0x16b0,0x6657,0x7676,0x4615,0x5634,

0xd94c,0xc96d,0xf90e,0xe92f,0x99c8,0x89e9,0xb98a,0xa9ab,

0x5844,0x4865,0x7806,0x6827,0x18c0,0x8e1,0x3882,0x28a3,

0xcb7d,0xdb5c,0xeb3f,0xfb1e,0x8bf9,0x9bd8,0xabbb,0xbb9a,

0x4a75,0x5a54,0x6a37,0x7a16,0xaf1,0x1ad0,0x2ab3,0x3a92,

0xfd2e,0xed0f,0xdd6c,0xcd4d,0xbdaa,0xad8b,0x9de8,0x8dc9,

0x7c26,0x6c07,0x5c64,0x4c45,0x3ca2,0x2c83,0x1ce0,0xcc1,

0xef1f,0xff3e,0xcf5d,0xdf7c,0xaf9b,0xbfba,0x8fd9,0x9ff8,

0x6e17,0x7e36,0x4e55,0x5e74,0x2e93,0x3eb2,0xed1,0x1ef0
};

static uint16_t CRC16_cal(uint8_t *ptr, uint32_t len, uint16_t crc_init)
{
 uint16_t crc, oldcrc16;
 uint8_t temp;
 crc = crc_init;
 while (len--!=0)
 {
 temp=(crc>>8)&0xff;
 oldcrc16=crc16_tab[*ptr^temp];
 crc=(crc<<8)^oldcrc16;
 ptr++;
 }
 //crc=~crc; //??
 return(crc);
}

static uint8_t crc_check_16bites(uint8_t* pbuf, uint32_t len,uint32_t* p_result)
{
uint16_t crc_result = 0;
crc_result= CRC16_cal(pbuf,len, 0);
*p_result = crc_result;
return 2;
}

void set_a8mini_yp_rate(int8_t yaw_rate, int8_t pitch_rate, mavlink_channel_t chan){
	a8mini_data[0]=0x55;//STX
	a8mini_data[1]=0x66;
	a8mini_data[2]=0x00;//CTRL
	a8mini_data[3]=0x02;//LEN
	a8mini_data[4]=0x00;
	a8mini_data[5]=0x00;//SEQ
	a8mini_data[6]=0x00;
	a8mini_data[7]=0x07;//CMD
	//DATA
	*(int8_t *)&a8mini_data[8]=yaw_rate;//yaw_rate
	*(int8_t *)&a8mini_data[9]=pitch_rate;//pitch_rate
	//CRC16
	uint16_t len=10;
	*(uint16_t *)&a8mini_data[10]=CRC16_cal(a8mini_data, len, 0);
	//send
	comm_send_buf(chan, a8mini_data, len+2);
}

void set_a8mini_yp_angle(int16_t yaw_angle, int16_t pitch_angle, mavlink_channel_t chan){
	a8mini_data[0]=0x55;//STX
	a8mini_data[1]=0x66;
	a8mini_data[2]=0x01;//CTRL
	a8mini_data[3]=0x04;//LEN
	a8mini_data[4]=0x00;
	a8mini_data[5]=0x00;//SEQ
	a8mini_data[6]=0x00;
	a8mini_data[7]=0x0E;//CMD
	//DATA
	a8mini_data[8]=yaw_angle&0xFF;//yaw_angle -135.0~135.0
	a8mini_data[9]=yaw_angle>>8;
	a8mini_data[10]=pitch_angle&0xFF;//pitch_rate -90.0~25.0
	a8mini_data[11]=pitch_angle>>8;
	//CRC16
	uint16_t len=12;
	*(uint16_t *)&a8mini_data[12]=CRC16_cal(a8mini_data, len, 0);
	//send
	comm_send_buf(chan, a8mini_data, len+2);
}

/* mode:
	0：拍照
	1：HDR切换(暂不支持)
	2：录像
	3：运动模式: 锁定模式
	4：运动模式: 跟随模式
	5：运动模式: FPV模式
	6：设置HDMI视频输出（仅ZT6、A8 mini支持，重启生效）
	7：设置CVBS视频输出（仅ZT6、A8 mini支持，重启生效）
	8：HDMI/CVBS视频输出全部关闭
 * */
void set_a8mini_camera(uint8_t mode, mavlink_channel_t chan){
	a8mini_data[0]=0x55;//STX
	a8mini_data[1]=0x66;
	a8mini_data[2]=0x00;//CTRL
	a8mini_data[3]=0x01;//LEN
	a8mini_data[4]=0x00;
	a8mini_data[5]=0x00;//SEQ
	a8mini_data[6]=0x00;
	a8mini_data[7]=0x0C;//CMD
	//DATA
	*(int8_t *)&a8mini_data[8]=mode;//yaw_rate
	//CRC16
	uint16_t len=9;
	*(uint16_t *)&a8mini_data[9]=CRC16_cal(a8mini_data, len, 0);
	//send
	comm_send_buf(chan, a8mini_data, len+2);
}
